#ifndef PROCESS_LOCK_H
#define PROCESS_LOCK_H

/* Created: CGP, 12/24/00
	An interface to the operating system (BeOS) semaphore mechanism, so we can keep
	the operating system dependent portion of the semaphore usage isolated.
 */

#include <Locker.h> // BeOS header

class ProcessLock {
	public:
		ProcessLock();
		~ProcessLock();
		
		// Lock & unlock the semaphore
		void Lock();
		void Unlock();
		
		// Check to see if the sempahore is locked
		bool IsLocked();
		
	private:
		BLocker *lock;
};

#endif